CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_cupomnaofiscal') THEN 
		DROP VIEW v_cupomnaofiscal;
		RAISE NOTICE 'v_cupomnaofiscal Dropada.';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_cupomnaofiscal
	AS SELECT cupom.cd_emp,
		cupom.cd_filial,
		cupom.cd_cx,
		cupom.dt_cupom,
		cupom.dt_cad,
		cupom.hr_cupom,
		cupom.tp_cupom_nao_fiscal AS tp_cupom,
		cupom.cd_mov,
		cupom.cd_ctr,
		cupom.nr_coo,
		cupom.st_cupom,
		cupom.cont_cupom_fisc AS contador_cupom_fiscal,
		cupom.cd_mov AS codigo_movimento,
		filial.cgc AS cgc_filial,
		filial.nm_fant AS nm_filial,
		cupom.vlr_to_cupom AS vlr_tot_cupom,
		cupom.vlr_dinh,
		cupom.vlr_cartao,
		cupom.vlr_chqs_a_vista + cupom.vlr_chqs_a_prz AS vlr_chqs,
		cupom.cd_oper_cel,
		cupom.nr_cel_recarga,
		cupom.vlr_recarga_cel,
		cupom.nm_oper_cel,
		cupom.nr_serie_imp AS nr_serie_ecf,
		cupom.vs_pdv AS versao_pdv,
		cupom.vs_pdv_rc AS versao_pdv_rc,
		operador.cd_usu AS cd_operador,
		operador.nm_usu AS nm_operador,
		NULLIF(COALESCE(cupom.vlr_dinh, 0::numeric) <> 0::numeric, false) AS contem_dinheiro,
		NULLIF(COALESCE(cupom.vlr_recarga_cel, 0::numeric) <> 0::numeric, false) AS contem_recarga_cel,
		NULLIF(cupom.st_cupom <> 0::numeric, false) AS is_cancelado,
		COALESCE(cupom.flag_consolidado, 0) AS flag_consolidado,
		cupom.tp_cupom_nao_fiscal = 0::numeric AS is_fatura,
		cupom.tp_cupom_nao_fiscal = 1::numeric AS is_doacao,
		cupom.tp_cupom_nao_fiscal = 2::numeric AS is_diversos,
		cupom.tp_cupom_nao_fiscal = 3::numeric AS is_recarga,
		cupom.cd_ctr AS doacao_id,
		entidade.cd_entid AS doacao_favor_id,
		entidade.nm_entid AS doacao_favor_nome,
		COALESCE(fatura.cd_ctr_pgto, parcela.cd_ctr_pgto) AS fatura_rec_id,
		fatura.cd_rc_deb AS fatura_id,
		fatura.vlr_sld_dp AS fatura_vlr,
		fatura.vlr_sld_dp AS fatura_vlr_sld,
		fatura.vlr_min_pgto AS fatura_vlr_min,
		fatura.vlr_pago AS fatura_vlr_cred,
		parcela.cd_ctr_parc AS parcela_id,
		parcela.vlr_parc AS parcela_vlr,
		parcela.vlr_pago AS parcela_vlr_cred,
		diversos.dt_vencto AS diversos_venc,
			CASE
				WHEN diversos.cd_recb_pdv <> 0 THEN diversos.cd_recb_pdv
				ELSE 0::bigint
			END AS diversos_id,
		diversos.ident_recb_pdv AS diversos_codigo,
		0 AS st_vd,
		cupom.hash_protocolo,
		cupom.st_pend_estorno,
		fatura.st_paga AS fatura_st_paga,
		fatura.tp_pgto_offline AS fatura_offline,
		fatura.vlrjuros AS fatura_vlr_juro,
		fatura.vlrdesconto AS fatura_vlr_desc,
		fatura.nrfatura AS fatura_nr_fatura,
		fatura.dt_vencto AS fatura_dt_vencto,
		parcela.st_paga AS parcela_st_paga,
		parcela.tp_pgto_offline AS parcela_offline,
		COALESCE(cupom.obs_cupom, ''::character varying) AS obs_cupom,
		COALESCE(cupom.cd_mt_sangria, 0::numeric) AS "coalesce",
		cupom.cd_mt_sangria,
		cupom.cd_cli,
		coalesce(cupom.cd_vd_doacao, 0) as cd_vd
	   FROM pdv_cupom_nao_fiscal cupom
		 LEFT JOIN prc_filial filial ON cupom.cd_emp = filial.cd_emp AND cupom.cd_filial = filial.cd_filial
		 LEFT JOIN pdv_cupom_nao_fiscal_rec_fatura fatura ON cupom.cd_emp = fatura.cd_emp AND cupom.cd_filial = fatura.cd_filial AND cupom.cd_cx = fatura.cd_cx AND cupom.cd_ctr = fatura.cd_ctr AND fatura.st_paga = 1::numeric
		 LEFT JOIN pdv_cupom_nao_fiscal_rec_parc_cred parcela ON cupom.cd_emp = parcela.cd_emp AND cupom.cd_filial = parcela.cd_filial AND cupom.cd_cx = parcela.cd_cx AND cupom.cd_ctr = parcela.cd_ctr
		 LEFT JOIN pdv_cupom_nao_fiscal_est_recb_pdv diversos ON cupom.cd_emp = diversos.cd_emp AND cupom.cd_filial = diversos.cd_filial AND cupom.cd_cx = diversos.cd_cx AND cupom.cd_ctr = diversos.cd_ctr
		 LEFT JOIN pdv_cupom_nao_fiscal_est_entid_doacao doacao ON cupom.cd_emp = doacao.cd_emp AND cupom.cd_filial = doacao.cd_filial AND cupom.cd_cx = doacao.cd_cx AND cupom.cd_ctr = doacao.cd_ctr
		 LEFT JOIN est_entidade_doacao entidade ON doacao.cd_emp = entidade.cd_emp AND doacao.cd_entid = entidade.cd_entid
		 LEFT JOIN glb_usu operador ON cupom.cd_usu = operador.cd_usu
	  WHERE cupom.st_cupom >= 0::numeric AND NOT (cupom.st_cupom = 2::numeric AND NOT cupom.tp_cupom_nao_fiscal = 0::numeric);

	-- Permissions

	ALTER TABLE public.v_cupomnaofiscal OWNER TO postgres;
	
	RAISE NOTICE 'v_cupomnaofiscal Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();